#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Hypnotic flowersMod01.fsh  by ManuManu 
//https://www.shadertoy.com/view/WdSBWD
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

		
vec3 palette( float t, vec3 a, vec3 b, vec3 c, vec3 d )
{
    return a + b * cos( 2.*3.14159 * ( c * t + d) );
}

vec3 MyPalette1( float t )
{
    return palette( t, vec3(.8, .5, .4), vec3(.2,.4,.2), vec3( .5), vec3( 0., .25, .25));
}
vec3 MyPalette2( float t )
{
    return palette( t, vec3(.5, .5, 5), vec3(.5, .5, .5), vec3( 1., 0.7,0.4), vec3( 0., .15, .2));
}
vec3 MyPalette3( float t )
{
    return palette( t, vec3(.5), vec3(.5), vec3( 1.), vec3( 0.3, .2, .2));
}
vec3 MyPalette4( float t )
{
    return palette( t, vec3(.5), vec3(.5), vec3( 1.,1.,0.5), vec3( 0.8, .9, .3));
}
vec3 MyPalette5( float t )
{
    return palette( t, vec3(.8, .5, .4), vec3(.2), vec3( .5,.5,0.5), vec3( 0., .9, .3));
}

// nice palettes from shane :
vec3 MyPalette6(float t )
{
	return .8 + .2*cos(6.3*t + vec3(0, 23, 21));
}
vec3 MyPalette7(float t )
{
	return .5 + .4*cos(6.3*t + vec3(2, 1, 0));
}
vec3 MyPalette8(float t )
{
	return .6 + .4*cos(6.*t + vec3(5, 3, 1));
}
    // Etc.
    //vec3 col = .5 + .4*cos(6.3*h21(d.yz) + vec3(2, 1, 0));
    //vec3 col = .6 + .4*cos(6.*h21(d.yz) + vec3(5, 3, 1));

vec3 Flower( vec2 uv, float paletteShift )
{
    vec2 st = vec2( atan(uv.x, uv.y), length(uv ) );
    uv = vec2( st.x/3.14159 + iTime*.2, st.y);

    float myX = mod (uv.x, .2) -.1;
    float func = -5.*myX * myX + .2;
    float val = func - uv.y;
    
    val = smoothstep( 0., 0.01, val);

    return val * MyPalette1(uv.y*7. + paletteShift);
}

vec3 Flower2( vec2 uv, float paletteShift )
{
    vec2 st = vec2( atan(uv.x, uv.y), length(uv ) );
    uv = vec2( st.x/3.14159 + iTime*.2, st.y);

    float myX = mod (uv.x, .2) -.1;
    float func = -10.*myX * myX + .2;
    float val = func - uv.y;
    
    val = smoothstep( 0., 0.01, val);

    return val * MyPalette3(uv.y*7. + paletteShift);
}

vec3 flowersField1( vec2 uv)
{
    uv = mod( uv, .5 ) - 0.25;
    vec3 col = vec3(0);
    
    float fact = 1.;
    float paletteShift = 0.;
    for ( int i = 0; i < 10; i++)
    {
        vec3 flowerCol = Flower(uv * fact, paletteShift);
        if ( length(flowerCol) > 0.)
            col = flowerCol;
        fact *= 1.1;
        paletteShift += 1.5 + iTime*0.1;
                
    }
    return col;
}
vec3 flowersField2( vec2 uv)
{
    uv = mod( uv, .5 ) - 0.25;
    vec3 col = vec3(0);
    
    float fact = 1.;
    float paletteShift = 0.;
    for ( int i = 0; i < 10; i++)
    {
        vec3 flowerCol = Flower2(uv * fact, paletteShift);
        if ( length(flowerCol) > 0.)
            col = flowerCol;
        fact *= 1.1;
        paletteShift += 1.5 + iTime*0.1;
                
    }
    return col;
}
mat2 rot( float a )
{
    float c = cos(a);
    float s = sin(a);
    return mat2( c, s, -s, c);
}
vec2 moveUV( vec2 uv, float angle, float zoom, vec2 dep )
{
    return rot( angle ) * ( ( uv * zoom) + dep );
}



//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = fragCoord/iResolution.xy;
    uv  = (uv - .5)*2.;
    uv.x  *= iResolution.x / iResolution.y;
    
    vec2 realUv = uv;
	vec3 col = length(uv*.3) *vec3(0.3,0.3,0.8);

    // general camera move :
    uv = moveUV( uv, sin(iTime*.2), .28+.13*sin(iTime*.51), vec2(cos(iTime*.001), sin(iTime*.00039)));

    
    
    float fact = 1.;
    const float factInc = 1.3;
    for( float i = 0.; i < 2.; i+=1.)
    {
        vec2 p = moveUV( uv, sin(iTime*.2), fact, vec2(cos(iTime*.011), sin(iTime*.007)));
    	vec3 flower1 = flowersField1(p);
        if (length(flower1) > 0. )
            col = flower1;
        p = moveUV( uv, sin(iTime*.2), fact*factInc, vec2(cos(iTime*.001), sin(iTime*.007)));
		vec3 flower2 = flowersField2(p*fact*factInc);
        if (length(flower2) > 0. )
            col = flower2;
        fact = fact * factInc * factInc;
        
    }
    
    // Output to screen
    col*=smoothstep(2.4,1.,length(realUv));
    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

